#include <cvirte.h>		
#include <userint.h>
#include "AIStpCmd.h"
#include <windows.h>
#include <formatio.h>
#include <stdlib.h>

#include "drvlinx.h"
#include "dlcodes.h"

static int panelHandle;

DL_SERVICEREQUEST *SR = NULL;
HINSTANCE DriverInstance = NULL;
HWND handle;
int winMsg;
void* callbackData;
int callbackID;
int status;
int devNum=0; /*Set logical device number of your board here*/
int chanNum=0; /*Set AI Channel number here*/
int samples=500; /*Set number of samples here*/
WORD taskid; /*DriverLINX task ID*/
HANDLE hMem;   // handle for Global Memory allocation for our buffer list


void showMessage(DL_SERVICEREQUEST*);
void CVICALLBACK myHandler(WinMsgWParam wParam, WinMsgLParam lParam, void* callbackData);
void readingsDone(int bufnum);
void clearBuffers(void);

int CVICALLBACK quit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			clearBuffers(); /*Clear existing buffers*/
			free(SR); /*Free memory used by service request*/
			CloseDriverLINX(DriverInstance); /*Close DriverLINX driver*/
			status=UnRegisterWinMsgCallback(callbackID); /*clear the message handler*/
			QuitUserInterface (0);
			break;
		}
	return 0;
}

int CVICALLBACK OpenDevice (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		    /*Find window handle of panel*/
			status=GetPanelAttribute(panelHandle, ATTR_SYSTEM_WINDOW_HANDLE,(int*)&handle);
			/*Allocate service request*/
			SR=(DL_SERVICEREQUEST*)malloc(sizeof(DL_SERVICEREQUEST));
			/*Open DriverLINX driver*/
			DriverInstance=OpenDriverLINX(handle,"kpci3100"); // pass in your driver name here
			/*
			  driver name for other board families:
			  
			  DAS-1800 Series has driver name of kmb1800
			  DAS-1700 Series: kmb1700
			  DAS-800 Series:  kmb800
			  KPCI-3101/2/3/4 or KPCI-3110/16 : kpci3100
			  KPCI-3108, KPCI-3107 : kpci3108
			  KPCI-1801HC, KPCI-1802HC:  kpci1800
			*/
			/*Initialize service request*/
			memset(SR,0,sizeof(DL_SERVICEREQUEST));
			/*Set service request size field*/
			DL_SetServiceRequestSize(*SR);
			SR->device=devNum; /*Set logical device number*/ 
			SR->operation=INITIALIZE; /*initialize device*/
			SR->subsystem=DEVICE;
			SR->mode=OTHER;
			SR->hWnd=handle; /*Set window handle of application*/
			DriverLINX(SR); /*Execute service request*/
			showMessage(SR); /*Show any errors*/
			winMsg=RegisterWinMsgCallback(myHandler, DL_MESSAGE, callbackData, 0,
				&callbackID, 0); /*Register message handler to intercept buffer filled messages*/
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON_3,
									   ATTR_DIMMED, 0); /*Enable Start button*/
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON,
										ATTR_DIMMED, 1); /*Disable Open Device button*/
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON_2,
										ATTR_DIMMED, 0); /*Enable Quit button*/
										
			break;
		}
	return 0;
}

int __stdcall WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                       LPSTR lpszCmdLine, int nCmdShow)
{
	if (InitCVIRTE (hInstance, 0, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "AIStpCmd.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

void showMessage(DL_SERVICEREQUEST* mSR)
{
  mSR->operation=MESSAGEBOX; /*Messagebox operation will show any errors which have occurred*/
  DriverLINX(mSR); /*Execute Service Request*/
  return;
}

/*The message handler*/
void CVICALLBACK myHandler(WinMsgWParam wParam, WinMsgLParam lParam, void* callbackData)
{
	int bufIndex;
	switch(wParam)
	{
	case DL_BUFFERFILLED: /*Did a buffer fill?*/
		bufIndex=getBufIndex(lParam); /*Get the number of the buffer which filled*/
		readingsDone(bufIndex); /*Process buffer*/
		break;
	}
}
	
	


int CVICALLBACK sample (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
		
{

	switch (event)
		{
		case EVENT_COMMIT:
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON_4,
									   ATTR_DIMMED, 0); /*Enable Stop button*/
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON_3,
										ATTR_DIMMED, 1); /*Disable Start button*/
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON_2,
									   ATTR_DIMMED, 1); /*Disable Quit button*/
			clearBuffers(); /*Clear any existing buffers*/
			SR->operation=START; /*Start operation*/
			SR->subsystem=AI;
			SR->mode=DMA; /*Use interrupt mode if your board has no DMA feature*/
			SR->channels.nChannels=1; /*Acquire from one channel*/
			SR->channels.chanGain[0].channel=chanNum; /*Set channel number*/
			SR->channels.chanGain[0].gainOrRange=Gain2Code(devNum,AI,-1.0); /*Use bipolar unity gain*/
			SR->start.typeEvent=COMMAND; /*Start on command*/
			SR->timing.typeEvent=RATEEVENT; /*Use rate generator to time acquisition*/
			SR->stop.typeEvent=COMMAND; /*Stop on command*/
			/*
			  A stop on command or stop on trigger type task will often require that
			  the finite number of allocated buffers be recycled as the running of the 
			  task goes on and on.
			  
			  In this condition, DriverLINX has some guidelines for buffering:
			  
			  - use no fewer than 3 buffers
			  - sum of all buffers should account for 1 second worth of data collection
			  
			  For sample rate of 1000 Hz, this would mean total buffer should be no less than
			  1000 samples distributed in three or more buffers.  So you could have ten 100 point
			  buffers, five 200 point buffers, or three 333 point buffers, etc.
			  
			  - adjust buffer size such that they will not fill up and post a buffer
			    filled message faster than is practical for Windows Message processing
			    rates.  This will be approx 10msec;  keep the buffer size, for the sampling
			    rate, such that buffers arrive no faster than 10 msec intervals
			*/
			
			
			hMem = GlobalAlloc(GHND, DL_BufferListBytes(3)); // allocate bytes from heap
			// GHND: make it movable in heap and init elements to zero
			SR->lpBuffers= (LPVOID)GlobalLock(hMem);  //translate handle to a pointer and assign this to our SR structure
			 
			/*Allocate a buffer list */
			SR->lpBuffers->notify=NOTIFY; /*Enable buffer filled message*/
			SR->lpBuffers->nBuffers=3; /*Use three buffers*/
			SR->lpBuffers->bufferSize=Samples2Bytes(devNum,AI,0,samples); /*Set buffer size in bytes for 1000 samples*/
			SR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT, SR->lpBuffers->bufferSize); /*Allocate first buffer*/
			SR->lpBuffers->BufferAddr[1]=BufAlloc(GBUF_INT, SR->lpBuffers->bufferSize); /*Allocate second buffer*/
			SR->lpBuffers->BufferAddr[2]=BufAlloc(GBUF_INT, SR->lpBuffers->bufferSize);
			/*  Specify our timing information */
			SR->timing.u.rateEvent.channel=DEFAULTTIMER; /*Use default clock for AI pacing*/
			SR->timing.u.rateEvent.mode=RATEGEN; /*Use clock in rate generator mode*/
			SR->timing.u.rateEvent.clock=INTERNAL1; /*Use Internal1 for time base*/
			SR->timing.u.rateEvent.gate=DISABLED; /*no gating*/
			SR->timing.u.rateEvent.period=Sec2Tics(devNum,AI,INTERNAL1, 0.001); /*use a period of 1mS*/
			DriverLINX(SR); /*Start AI task*/
			showMessage(SR); /*Show any errors*/
			taskid=SR->taskId; /*Save the task ID so we can stop it later...*/
			break;
		}
	return 0;
}

void readingsDone(int bufnum)
{
	float* readings;
	char read[20];
	char bufferNumber[5];
  	int index;
  	readings = (float*)malloc(samples*sizeof(float)); /*Make a temporary buffer to hold the converted readings*/
  	SR->operation=CONVERT; /*Start convert operation*/
  	SR->mode=OTHER;
  	SR->start.typeEvent=DATACONVERT;
  	SR->start.u.dataConvert.startIndex=0; /*Start at element zero*/
  	SR->start.u.dataConvert.nSamples=samples;
  	SR->start.u.dataConvert.numberFormat=tSINGLE;
  	SR->start.u.dataConvert.scaling=0.0f;
  	SR->start.u.dataConvert.offset=0.0f;
  	SR->start.u.dataConvert.wBuffer=bufnum;
  	SR->start.u.dataConvert.lpBuffer=readings;
  	DriverLINX(SR);
  	showMessage(SR);
  	status = Fmt(read, "%f", readings[0]);
	status = ResetTextBox (panelHandle, PANEL_TEXTBOX, "");
	status = InsertTextBoxLine (panelHandle, PANEL_TEXTBOX, 0, read);
	status = Fmt(bufferNumber, "%d", bufnum); 
	status = ResetTextBox (panelHandle, PANEL_TEXTBOX_2, "");
	status = InsertTextBoxLine (panelHandle, PANEL_TEXTBOX_2, 0, bufferNumber);
	free(readings); /*Free the temporary buffer*/
}

void clearBuffers(void)
{
	if(SR!=NULL)
	{
		if(SR->lpBuffers != NULL)
		{
			if(SR->lpBuffers->BufferAddr[0] != NULL)
			{
				BufFree(SR->lpBuffers->BufferAddr[0]);
				BufFree(SR->lpBuffers->BufferAddr[1]);
				BufFree(SR->lpBuffers->BufferAddr[2]);
				SR->lpBuffers->BufferAddr[0] = NULL;
				SR->lpBuffers->BufferAddr[1] = NULL;
				SR->lpBuffers->BufferAddr[2] = NULL;
			}
		GlobalFree(hMem);	 // free up our allocated heap
		SR->lpBuffers=NULL;
		}
	}
}

int CVICALLBACK stop (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			SR->operation=STOP; /*Stop the AI task*/
			SR->mode=DMA; /*Have to "remind" it what kind of operation was running*/
			SR->taskId=taskid; /*Restore the task ID, because the convert operation created a different one*/
			
			DriverLINX(SR);
			showMessage(SR);
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON_3,
									   ATTR_DIMMED, 0); /*Enable Start button*/
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON_4,
									   ATTR_DIMMED, 1); /*Disable Stop button*/
			status = SetCtrlAttribute (panelHandle, PANEL_COMMANDBUTTON_2,
									   ATTR_DIMMED, 0); /*Enable Quit button*/
			
			break;
		}
	return 0;
}
